<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class VerifySignature
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    protected $signatureService;

    public function __construct(\App\Services\SignatureService $signatureService)
    {
        $this->signatureService = $signatureService;
    }

    public function handle(Request $request, Closure $next): Response
    {
        $apiKey = $request->header('X-Site-Key');
        $signature = $request->header('X-Signature');

        if (!$apiKey || !$signature) {
            return response()->json(['error' => 'Missing authentication headers'], 401);
        }

        $site = \App\Models\Site::where('api_key', $apiKey)->where('is_active', true)->first();

        if (!$site) {
            return response()->json(['error' => 'Invalid API Key'], 401);
        }

        // Verify signature
        if (!$this->signatureService->verifySignature($request->all(), $signature, $site->api_secret)) {
            return response()->json(['error' => 'Invalid Signature'], 401);
        }

        // Attach site to request for Controller usage
        $request->attributes->set('site', $site);

        return $next($request);
    }
}
